/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.IVWExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.VWInstruction;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public final class VWAssignmentInstructionTableModel
extends AbstractTableModel
implements IVWExpressionCellEditorTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_NAME = 0;
    public static final int COL_EXPRESSION = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private Vector m_rowData = null;
    private String m_expression = null;

    public VWAssignmentInstructionTableModel(VWAuthPropertyData authPropertyData, VWInstructionDefinition instructionDef) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_instructionDef = instructionDef;
            this.m_rowData = new Vector();
            this.m_expression = new String();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String[] getItemAt(int nRowIndex) {
        String[] assignment = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            assignment = (String[])this.m_rowData.elementAt(nRowIndex);
        }
        return assignment;
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        try {
            this.m_instructionDef = instructionDef;
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void up(int nRowIndex) {
        try {
            if (nRowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int nRowIndex) {
        try {
            if (nRowIndex < this.getRowCount() - 2) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        block3: {
            String[] assignment = null;
            try {
                assignment = this.getItemAt(nRowIndex);
                if (assignment != null) {
                    this.m_rowData.removeElementAt(nRowIndex);
                    this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block3;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    public void reinitialize() {
        try {
            this.m_expression = "";
            this.m_rowData.removeAllElements();
            if (this.m_instructionDef != null) {
                int assignmentsCount;
                String[][] assignments = VWInstruction.AssignInstructionGetAssignment(this.m_instructionDef);
                if (assignments != null && (assignmentsCount = assignments.length) > 0) {
                    for (int i = 0; i < assignmentsCount; ++i) {
                        this.m_rowData.addElement(assignments[i]);
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        Class<String> resultClass = null;
        switch (nColumnIndex) {
            case 0: {
                resultClass = String.class;
                break;
            }
            case 1: {
                resultClass = String.class;
            }
        }
        return resultClass;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        String resultString = null;
        switch (nColumnIndex) {
            case 0: {
                resultString = VWResource.s_nameStr;
                break;
            }
            case 1: {
                resultString = VWResource.s_expressionStr;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        String object = new String("");
        try {
            String[] assignment = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (assignment == null || assignment[0] == null) break;
                    object = assignment[0];
                    break;
                }
                case 1: {
                    object = assignment != null && assignment[1] != null ? assignment[1] : this.m_expression;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return object;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateExpression(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block6: {
            String[] assignment = null;
            String newName = null;
            try {
                if (aValue != null && aValue instanceof String && (newName = (String)aValue).length() > 0) {
                    assignment = this.getItemAt(nRowIndex);
                    if (assignment != null) {
                        assignment[0] = newName;
                        this.m_authPropertyData.setDirty();
                        this.fireTableCellUpdated(nRowIndex, 0);
                    } else {
                        assignment = new String[2];
                        if (assignment != null) {
                            assignment[0] = newName;
                            assignment[1] = this.m_expression;
                            this.m_rowData.addElement(assignment);
                            this.m_authPropertyData.setDirty();
                            this.m_expression = "";
                        }
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    }
                    this.updateInstructionDefinition();
                }
            }
            catch (Exception ex) {
                if (this.m_authPropertyData == null) break block6;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void onUpdateExpression(Object aValue, int nRowIndex) {
        block5: {
            String[] assignment = null;
            try {
                if (aValue != null && aValue instanceof String) {
                    assignment = this.getItemAt(nRowIndex);
                    if (assignment != null) {
                        assignment[1] = (String)aValue;
                        this.m_authPropertyData.setDirty();
                        String[][] newAssignments = new String[this.m_rowData.size()][2];
                        this.m_rowData.copyInto((Object[])newAssignments);
                        this.updateInstructionDefinition();
                    } else {
                        this.m_expression = (String)aValue;
                    }
                    this.fireTableCellUpdated(nRowIndex, 2);
                }
            }
            catch (Exception ex) {
                if (this.m_authPropertyData == null) break block5;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void updateInstructionDefinition() {
        String[][] assignments = new String[this.m_rowData.size()][2];
        this.m_rowData.copyInto((Object[])assignments);
        VWInstruction.AssignInstructionSetAssignment(this.m_instructionDef, assignments);
    }
}

